package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.PrivacySettingModel
import com.qboxus.tictic.repositories.UserRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class PrivacyPolicyViewModel(
    private val context: Context,
    private val userRepository: UserRepository

) : ViewModel(){


    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }



    var strVideoDownload: String? = null
    var strDirectMessage: String? = null
    var strDuet: String? = null
    var strLikedVideo: String? = null
    var strVideoComment: String? = null
    var orderView: String? = null


    val _privacyPolicyLiveData: MutableLiveData<ApiResponce<PrivacySettingModel>> = MutableLiveData()
    val privacyPolicyLiveData: LiveData<ApiResponce<PrivacySettingModel>> get() = _privacyPolicyLiveData

    fun addPrivacySetting(){
        viewModelScope.launch {

            val param = JSONObject().apply {
                put("videos_download", strVideoDownload)
                put("direct_message", strDirectMessage)
                put("duet", strDuet)
                put("liked_videos", strLikedVideo)
                put("video_comment", strVideoComment)
                put("order_history", orderView)
                put("user_id", sharedPreferences.getString(Variables.U_ID, ""))
            }

            userRepository.addPolicySettings(param, _privacyPolicyLiveData)
        }
    }




}

class PrivacyPolicyFactory(
    private val context: Context,
    private val userRepository: UserRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(PrivacyPolicyViewModel::class.java)) {
            return PrivacyPolicyViewModel(context,userRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}